% Code for: Capital Reallocation and Aggregate Productivity
% R. Cooper & I. Schott
% Code version: September 2022

Tx      = length(kt);
Rt      = zeros(Tx,1);
sd_Rt   = zeros(Tx,1);
sigt    = zeros(Tx,1);
x       = zeros(1,Tx); % 1 x K
x(1)    = 1;
kgt     = zeros(PARMS.N,PARMS.N,Tx);
dist    = zeros(PARMS.N^2,Tx);


% Initial period
kgt(:,:,1)  = kron(ones(PARMS.N,1),kt(1,:));
dist(:,1)   = steady.probst; % initial distribution
lenk        = length(kt(1,:));

for t = 2:Tx
    % Prior to the new eps shock: distribution is dist and there are x
    % firms in each type of distribution
    % In this period, all ADJUSTING PLANTS choose:
    kgt(:,:,t) = kron(ones(PARMS.N,1),kt(t,:));
    % There are previously chosen capital vectors
    aux         = zeros(t-1,1);
    aux_sd      = zeros(t-1,1);
    newcap      = reshape(kgt(:,:,t),1,[]);
    trans_adj   = steady.trans_pi;
    trans_noadj = steady.trans_nopi;

    for tt = 1:t-1
        % Adjusters:
        oldcap      = reshape(kgt(:,:,tt),[],1);
        R           = abs(oldcap - newcap); % Possible Reallocation
        % Capital reallocation between this type of capital and today's capital choice
        aux(tt)     = 1/2 * pit(t)*x(tt)*dist(:,tt)'*sum(trans_adj.*R,2);
        % The standard deviation of adjustment
        aux_sd(tt)  = pit(t) * x(tt) * std(R(:),reshape(dist(:,tt).*trans_adj,[],1));
        % The distribution of firms next period, conditional on adjusting
        dist(:,t)   = dist(:,t) + x(tt)*trans_adj'*dist(:,tt);
        % Non-adjusters: No reallocation, but distribution changes
        dist(:,tt)  = trans_noadj'*dist(:,tt);
    end
    % Total reallocation
    Rt(t)      = sum(aux);
    % Standard deviation of reallocation (could be rates)
    sd_Rt(t)   = sum(aux_sd);

    % Update distribution over vectors:
    x(t)        = pit(t) * sum(x(1:t-1));
    x(1:t-1)    = x(1:t-1) * (1-pit(t));
    % At this point all the distributions are end-of-period
    epsg        = kron(ones(1,PARMS.N),PARMS.eps);
    % Standard deviation in APK (output weighted)
    log_ARPKt   = reshape(log(epsg.*kgt(:,:,1:t).^(PARMS.ALPHA-1)),PARMS.N^2,[],1);
    q           = reshape(epsg.*kgt(:,:,1:t).^(PARMS.ALPHA),PARMS.N^2,[],1);
    w           = x(1:t).*dist(:,1:t); % weight
    sigt(t)    = std(log_ARPKt(:),q(:).*w(:));
end

Rt(1)       = steady.R;
sigt(1)     = steady.sig;


